/*
 * Decompiled with CFR 0.152.
 */
package fxlauncher;

import fxlauncher.FXManifest;
import fxlauncher.FxlauncherClassCloader;
import fxlauncher.LibraryFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.stream.Collectors;
import javafx.application.Application;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.bind.JAXB;

public abstract class AbstractLauncher<APP> {
    private static final Logger log = Logger.getLogger("AbstractLauncher");
    protected static FXManifest manifest;
    private String phase;

    protected void setupLogFile() throws IOException {
        String filename = System.getProperty("java.io.tmpdir") + File.separator + "fxlauncher.log";
        if (this.getParameters().getNamed().containsKey("logfile")) {
            filename = (String)this.getParameters().getNamed().get("logfile");
        }
        System.out.println("logging to " + filename);
        FileHandler handler = new FileHandler(filename);
        handler.setFormatter(new SimpleFormatter());
        log.addHandler(handler);
    }

    protected void checkSSLIgnoreflag() throws KeyManagementException, NoSuchAlgorithmException {
        if (this.getParameters().getUnnamed().contains("--ignoressl")) {
            this.setupIgnoreSSLCertificate();
        }
    }

    protected ClassLoader createClassLoader(Path cacheDir) {
        List<URL> libs = AbstractLauncher.manifest.files.stream().filter(LibraryFile::loadForCurrentPlatform).map(it -> it.toURL(cacheDir)).collect(Collectors.toList());
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        if (systemClassLoader instanceof FxlauncherClassCloader) {
            ((FxlauncherClassCloader)systemClassLoader).addUrls(libs);
            return systemClassLoader;
        }
        URLClassLoader classLoader = new URLClassLoader(libs.toArray(new URL[libs.size()]));
        Thread.currentThread().setContextClassLoader(classLoader);
        this.setupClassLoader(classLoader);
        return classLoader;
    }

    protected void updateManifest() throws Exception {
        this.phase = "Update Manifest";
        this.syncManifest();
    }

    protected boolean syncFiles() throws Exception {
        Path cacheDir = manifest.resolveCacheDir(this.getParameters().getNamed());
        log.info(String.format("Using cache dir %s", cacheDir));
        this.phase = "File Synchronization";
        if (this.getParameters().getUnnamed().contains("--offline")) {
            log.info("not updating files from remote, offline selected");
            return false;
        }
        List needsUpdate = AbstractLauncher.manifest.files.stream().filter(LibraryFile::loadForCurrentPlatform).filter(it -> it.needsUpdate(cacheDir)).collect(Collectors.toList());
        if (needsUpdate.isEmpty()) {
            return false;
        }
        Long totalBytes = needsUpdate.stream().mapToLong(f -> f.size).sum();
        Long totalWritten = 0L;
        for (LibraryFile lib : needsUpdate) {
            Path target = cacheDir.resolve(lib.file).toAbsolutePath();
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            URI uri = AbstractLauncher.manifest.uri.resolve(lib.file);
            InputStream input = this.openDownloadStream(uri);
            Throwable throwable = null;
            try {
                OutputStream output = Files.newOutputStream(target, new OpenOption[0]);
                Throwable throwable2 = null;
                try {
                    int read;
                    byte[] buf = new byte[65536];
                    while ((read = input.read(buf)) > -1) {
                        output.write(buf, 0, read);
                        totalWritten = totalWritten + (long)read;
                        Double progress = totalWritten.doubleValue() / totalBytes.doubleValue();
                        this.updateProgress(progress);
                    }
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (output == null) continue;
                    if (throwable2 != null) {
                        try {
                            output.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    output.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (input == null) continue;
                if (throwable != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                input.close();
            }
        }
        return true;
    }

    private InputStream openDownloadStream(URI uri) throws IOException {
        if (uri.getScheme().equals("file")) {
            return Files.newInputStream(new File(uri.getPath()).toPath(), new OpenOption[0]);
        }
        URLConnection connection = uri.toURL().openConnection();
        if (uri.getUserInfo() != null) {
            byte[] payload = uri.getUserInfo().getBytes(StandardCharsets.UTF_8);
            String encoded = Base64.getEncoder().encodeToString(payload);
            connection.setRequestProperty("Authorization", String.format("Basic %s", encoded));
        }
        return connection.getInputStream();
    }

    protected void createApplicationEnvironment() throws Exception {
        this.phase = "Create Application";
        if (manifest == null) {
            throw new IllegalArgumentException("Unable to retrieve embedded or remote manifest.");
        }
        List<String> preloadLibs = manifest.getPreloadNativeLibraryList();
        for (String preloadLib : preloadLibs) {
            System.loadLibrary(preloadLib);
        }
        Path cacheDir = manifest.resolveCacheDir(this.getParameters() != null ? this.getParameters().getNamed() : null);
        ClassLoader classLoader = this.createClassLoader(cacheDir);
        Class<?> appclass = classLoader.loadClass(AbstractLauncher.manifest.launchClass);
        this.createApplication(appclass);
    }

    protected void syncManifest() throws Exception {
        Path cacheDir;
        Map namedParams = this.getParameters().getNamed();
        String appStr = null;
        if (namedParams.containsKey("app")) {
            appStr = (String)namedParams.get("app");
            log.info(String.format("Loading manifest from 'app' parameter supplied: %s", appStr));
        }
        if (namedParams.containsKey("uri")) {
            String uriStr = (String)namedParams.get("uri");
            if (!uriStr.endsWith("/")) {
                uriStr = uriStr + "/";
            }
            log.info(String.format("Syncing files from 'uri' parameter supplied:  %s", uriStr));
            URI uri = URI.create(uriStr);
            URI app = appStr != null ? URI.create(appStr) : uri.resolve("app.xml");
            manifest = FXManifest.load(app);
            AbstractLauncher.manifest.uri = uri;
            return;
        }
        if (appStr != null) {
            manifest = FXManifest.load(new File(appStr).toURI());
            return;
        }
        URL embeddedManifest = AbstractLauncher.class.getResource("/app.xml");
        manifest = (FXManifest)JAXB.unmarshal((URL)embeddedManifest, FXManifest.class);
        Path manifestPath = manifest.getPath(cacheDir = manifest.resolveCacheDir(namedParams));
        if (Files.exists(manifestPath, new LinkOption[0])) {
            manifest = (FXManifest)JAXB.unmarshal((File)manifestPath.toFile(), FXManifest.class);
        }
        if (this.getParameters().getUnnamed().contains("--offline")) {
            log.info("offline selected");
            return;
        }
        try {
            FXManifest remoteManifest = FXManifest.load(manifest.getFXAppURI());
            if (remoteManifest == null) {
                log.info(String.format("No remote manifest at %s", manifest.getFXAppURI()));
            } else if (!remoteManifest.equals(manifest) && (remoteManifest.isNewerThan(manifest) || AbstractLauncher.manifest.acceptDowngrade.booleanValue())) {
                manifest = remoteManifest;
                JAXB.marshal((Object)manifest, (File)manifestPath.toFile());
            }
        }
        catch (Exception ex) {
            log.log(Level.WARNING, String.format("Unable to update manifest from %s", manifest.getFXAppURI()), ex);
        }
    }

    protected void setupIgnoreSSLCertificate() throws NoSuchAlgorithmException, KeyManagementException {
        log.info("starting ssl setup");
        TrustManager[] trustManager = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }};
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, trustManager, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
        HostnameVerifier hostnameVerifier = (s, sslSession) -> true;
        HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
    }

    protected boolean checkIgnoreUpdateErrorSetting() {
        return this.getParameters().getUnnamed().contains("--stopOnUpdateErrors");
    }

    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public FXManifest getManifest() {
        return manifest;
    }

    protected abstract Application.Parameters getParameters();

    protected abstract void updateProgress(double var1);

    protected abstract void createApplication(Class<APP> var1);

    protected abstract void reportError(String var1, Throwable var2);

    protected abstract void setupClassLoader(ClassLoader var1);
}

