/*
 * Decompiled with CFR 0.152.
 */
package fxlauncher;

import com.sun.javafx.application.ParametersImpl;
import fxlauncher.FXManifest;
import fxlauncher.LibraryFile;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.bind.JAXB;

public class CreateManifest {
    private static ArrayList<String> includeExtensions = new ArrayList();

    public static void main(String[] args) throws IOException, URISyntaxException {
        URI baseURI = URI.create(args[0]);
        String launchClass = args[1];
        Path appPath = Paths.get(args[2], new String[0]);
        String cacheDir = null;
        Boolean acceptDowngrade = null;
        Boolean stopOnUpdateErrors = null;
        String parameters = null;
        String whatsNew = null;
        String preloadNativeLibraries = null;
        Boolean lingeringUpdateScreen = false;
        Boolean stopOnUpdateErrorsDeprecated = null;
        if (args.length > 3) {
            ArrayList<String> rawParams = new ArrayList<String>();
            rawParams.addAll(Arrays.asList(args).subList(3, args.length));
            ParametersImpl params = new ParametersImpl(rawParams);
            Map named = params.getNamed();
            if (named != null) {
                if (named.containsKey("cache-dir")) {
                    cacheDir = (String)named.get("cache-dir");
                }
                if (named.containsKey("accept-downgrade")) {
                    acceptDowngrade = Boolean.valueOf((String)named.get("accept-downgrade"));
                }
                if (named.containsKey("stop-on-update-errors")) {
                    stopOnUpdateErrors = Boolean.valueOf((String)named.get("stop-on-update-errors"));
                }
                if (named.containsKey("preload-native-libraries")) {
                    preloadNativeLibraries = (String)named.get("preload-native-libraries");
                }
                if (named.containsKey("lingering-update-screen")) {
                    lingeringUpdateScreen = Boolean.valueOf((String)named.get("lingering-update-screen"));
                }
                if (named.containsKey("whats-new")) {
                    whatsNew = (String)named.get("whats-new");
                }
                if (named.containsKey("include-extensions")) {
                    includeExtensions.addAll(Arrays.stream(((String)named.get("include-extensions")).split(",")).filter(s -> s != null && !s.isEmpty()).collect(Collectors.toList()));
                }
            }
            StringBuilder rest = new StringBuilder();
            for (String raw : params.getRaw()) {
                if (raw.equals("--stopOnUpdateErrors")) {
                    stopOnUpdateErrorsDeprecated = true;
                    continue;
                }
                if (raw.startsWith("--cache-dir=") || raw.startsWith("--accept-downgrade=") || raw.startsWith("--stop-on-update-errors=") || raw.startsWith("--include-extensions=") || raw.startsWith("--preload-native-libraries=") || raw.startsWith("--whats-new") || raw.startsWith("--lingering-update-screen")) continue;
                if (rest.length() > 0) {
                    rest.append(" ");
                }
                rest.append(raw);
            }
            if (rest.length() > 0) {
                parameters = rest.toString();
            }
        }
        FXManifest manifest = CreateManifest.create(baseURI, launchClass, appPath);
        if (cacheDir != null) {
            manifest.cacheDir = cacheDir;
        }
        if (acceptDowngrade != null) {
            manifest.acceptDowngrade = acceptDowngrade;
        }
        if (parameters != null) {
            manifest.parameters = parameters;
        }
        if (preloadNativeLibraries != null) {
            manifest.preloadNativeLibraries = preloadNativeLibraries;
        }
        if (whatsNew != null) {
            manifest.whatsNewPage = whatsNew;
        }
        manifest.lingeringUpdateScreen = lingeringUpdateScreen;
        if (stopOnUpdateErrors != null) {
            manifest.stopOnUpdateErrors = stopOnUpdateErrors;
            if (stopOnUpdateErrorsDeprecated != null) {
                System.out.println("Warning: --stopOnUpdateErrors is deprecated. Overriding with --stop-on-update-errors.");
            }
        } else if (stopOnUpdateErrorsDeprecated != null) {
            manifest.stopOnUpdateErrors = stopOnUpdateErrorsDeprecated;
            System.out.println("Warning: --stopOnUpdateErrors is deprecated. Use --stop-on-update-errors instead.");
        }
        JAXB.marshal((Object)manifest, (File)appPath.resolve("app.xml").toFile());
    }

    public static FXManifest create(URI baseURI, String launchClass, final Path appPath) throws IOException, URISyntaxException {
        final FXManifest manifest = new FXManifest();
        manifest.ts = System.currentTimeMillis();
        manifest.uri = baseURI;
        manifest.launchClass = launchClass;
        if (!manifest.uri.getPath().endsWith("/")) {
            manifest.uri = new URI(String.format("%s/", baseURI.toString()));
        }
        Files.walkFileTree(appPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (!Files.isDirectory(file, new LinkOption[0]) && CreateManifest.shouldIncludeInManifest(file) && !file.getFileName().toString().startsWith("fxlauncher")) {
                    manifest.files.add(new LibraryFile(appPath, file));
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return manifest;
    }

    public static void setIncludeExtensions(List<String> includeExtensions) {
        CreateManifest.includeExtensions.addAll(includeExtensions);
    }

    private static boolean shouldIncludeInManifest(Path file) {
        String filename = file.getFileName().toString();
        for (String ext : includeExtensions) {
            if (!filename.toLowerCase().endsWith(String.format(".%s", ext.toLowerCase()))) continue;
            return true;
        }
        return false;
    }

    static {
        includeExtensions.addAll(Arrays.asList("jar", "war"));
    }
}

